<?php
session_start();

include 'include/head.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

if (isset($_POST['nom'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare('INSERT INTO cours (nom_cours, id_groupe2) VALUES (:nom, :groupe)');
        $requete->bindParam(':nom', $_POST['nom']);
        $requete->bindParam(':groupe', $_POST['groupe']);
        $requete->execute();

        $cours_id = $bdd->lastInsertId();

        $total = 0;
        for ($i = 1; $i < 6; $i++) {
            if ($_POST['coeff'.$i] != '') {
                $total += $_POST['coeff'.$i];
            }
        }

        if ($total != 1) {
            throw new Exception('La somme des coefficients ne fait pas 1');
        }

        for ($i = 1; $i < 6; $i++) {
            if ($_POST['professeur'.$i] != '') {
                $requete = $bdd->prepare('INSERT INTO enseigne_le_cours (id_professeur, id_cours) VALUES (:prof, :cours)');
                $requete->bindParam(':prof', $_POST['professeur'.$i]);
                $requete->bindParam(':cours', $cours_id);
                $requete->execute();
            }

            if ($_POST['note'.$i] != '' && $_POST['coeff'.$i] != '') {
                $requete = $bdd->prepare('INSERT INTO coefficient (type_note, id_cours3, coefficient) VALUES (:type_note, :cours, :coeff)');
                $requete->bindParam(':type_note', $_POST['note'.$i]);
                $requete->bindParam(':cours', $cours_id);
                $requete->bindParam(':coeff', $_POST['coeff'.$i]);
                $requete->execute();
            }
        }

        $bdd->commit();

        header('Location: cours.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }
}

$menu = '';
$requete = $bdd->prepare("SELECT id_professeur, nom_professeur, prenom_professeur FROM professeur");
$requete->execute();
while ( $row = $requete->fetch())
    $menu .= '<option value="'.htmlspecialchars($row['id_professeur']).'">'.htmlspecialchars($row['prenom_professeur'].' '.$row['nom_professeur']).'</option>';

include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"> Ajouter un cours </div>
                        <div class="panel-body">
                            <div class="form-group">
                                <form method="post">
                                    <label>Nom</label>
                                    <input class="form-control" name="nom">
                                    <label>Groupe</label>
                                    <select class="form-control" name="groupe">
                                        <option value="">Aucun</option>
                                        <?php
                                        $requete = $bdd->prepare("SELECT id, nom FROM groupe");
                                        $requete->execute();
                                        while ( $row = $requete->fetch())
                                            echo '<option value="'.htmlspecialchars($row['id']).'">'.htmlspecialchars($row['nom']).'</option>';
                                        ?>
                                    </select>
                                    <label>Professeur 1</label>
                                    <select class="form-control" name="professeur1">
                                        <option value="">Aucun</option>
                                        <?php echo $menu; ?>
                                    </select>
                                    <label>Professeur 2</label>
                                    <select class="form-control" name="professeur2">
                                        <option value="">Aucun</option>
                                        <?php echo $menu; ?>
                                    </select>
                                    <label>Professeur 3</label>
                                    <select class="form-control" name="professeur3">
                                        <option value="">Aucun</option>
                                        <?php echo $menu; ?>
                                    </select>
                                    <label>Professeur 4</label>
                                    <select class="form-control" name="professeur4">
                                        <option value="">Aucun</option>
                                        <?php echo $menu; ?>
                                    </select>
                                    <label>Professeur 5</label>
                                    <select class="form-control" name="professeur5">
                                        <option value="">Aucun</option>
                                        <?php echo $menu; ?>
                                    </select>
                                    <label>Note 1</label>
                                    <select class="form-control" name="note1">
                                        <option value="">Aucune</option>
                                        <option value="DE">DE</option>
                                        <option value="TP">TP</option>
                                        <option value="PRJ">PRJ</option>
                                    </select>
                                    <label>Coefficient note 1</label>
                                    <input class="form-control" name="coeff1">
                                    <label>Note 2</label>
                                    <select class="form-control" name="note2">
                                        <option value="">Aucune</option>
                                        <option value="DE">DE</option>
                                        <option value="TP">TP</option>
                                        <option value="PRJ">PRJ</option>
                                    </select>
                                    <label>Coefficient note 2</label>
                                    <input class="form-control" name="coeff2">
                                    <label>Note 3</label>
                                    <select class="form-control" name="note3">
                                        <option value="">Aucune</option>
                                        <option value="DE">DE</option>
                                        <option value="TP">TP</option>
                                        <option value="PRJ">PRJ</option>
                                    </select>
                                    <label>Coefficient note 3</label>
                                    <input class="form-control" name="coeff3">
                                    <label>Note 4</label>
                                    <select class="form-control" name="note4">
                                        <option value="">Aucune</option>
                                        <option value="DE">DE</option>
                                        <option value="TP">TP</option>
                                        <option value="PRJ">PRJ</option>
                                    </select>
                                    <label>Coefficient note 4</label>
                                    <input class="form-control" name="coeff4">
                                    <label>Note 5</label>
                                    <select class="form-control" name="note5">
                                        <option value="">Aucune</option>
                                        <option value="DE">DE</option>
                                        <option value="TP">TP</option>
                                        <option value="PRJ">PRJ</option>
                                    </select>
                                    <label>Coefficient note 5</label>
                                    <input class="form-control" name="coeff5">
                                    <br />
                                    <input type="submit">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
